/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.Collections;
using System.Reflection;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Lifetime;
using System.Drawing;

using Borland.Eco.DataRepresentation;
using Borland.Eco.Persistence;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Globalization;

namespace Borland.Eco.Persistence.Remoting
{
	[ToolboxBitmap(typeof(PersistenceMapperClient), "Borland.Eco.Persistence.Remoting.PersistenceMapperClient.bmp")]
	[ToolboxItem(true)]
	public sealed class PersistenceMapperClient: PersistenceMapper
	{
		private IPersistenceMapper m_PMProxy;
		private string m_Url = "";
		private ITypeSystemService m_TypeSystemService;
		private readonly Hashtable m_Adapters = new Hashtable();

		[Browsable(true)]
		[DefaultValue("")]
		[LocalizableCategory(typeof(PersistenceStringRes), "sCategoryRemoting")]
		[LocalizableDescription(typeof(PersistenceStringRes), "sPropertyUrl")]

		public string Url
		{
			get { return m_Url; }
			set { m_Url = value; }
		}

		private IPersistenceMapper GetMapper(bool refresh)
		{
			// Handle timeouts etc
			if (m_PMProxy == null || refresh)
			{
				IRemotePersistenceMapperProvider server =
				  (IRemotePersistenceMapperProvider)RemotingServices.Connect(typeof(IPersistenceMapper), Url);
				m_PMProxy = server.GetPersistenceMapper(-1 /*FIXME hash on typesystem*/);

			}
			return m_PMProxy;
		}

		///<exception cref="InvalidOperationException">Thrown if the client is already set up with a different <see cref="ITypeSystemService"/>.</exception>
		public override IPersistenceMapper GetPersistenceMapper(ITypeSystemService typeSystemService)
		{
			lock(this)
			{
				if ((m_TypeSystemService != typeSystemService) && (m_Adapters.Count > 0))
					throw new InvalidOperationException(PersistenceStringRes.sPersistenceMapperInUseWithOtherTypeSystem);
				m_TypeSystemService = typeSystemService;
				IPersistenceMapper pm = new ClientMapperImpl(this);
				m_Adapters.Add(pm, pm);
				return pm;
			}
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="persistenceMapper"/> is null</exception>
		public override void ReturnPersistenceMapper(IPersistenceMapper persistenceMapper)
		{
			if (persistenceMapper == null) throw new ArgumentNullException("persistenceMapper"); // do not localize
			lock(this)
			{
				((ClientMapperImpl)persistenceMapper).DeActivate();
				m_Adapters.Remove(persistenceMapper);
				if (m_Adapters.Count == 0)
					m_PMProxy = null; // CHECKME more active disconnect?
			}
		}

		private sealed class ClientMapperImpl: IPersistenceMapper
		{
			private PersistenceMapperClient m_Owner;

			private static readonly TimeSpan EnsuranceTime = new TimeSpan(0, 1, 0);   // 1 minute should be plenty

			public ClientMapperImpl(PersistenceMapperClient owner): base()
			{
				m_Owner = owner;
			}

			private IPersistenceMapper GetMapper()
			{
				return m_Owner.GetMapper(false);
			}

			private IPersistenceMapper GetEnsuredMapper()
			{
				IPersistenceMapper pm = m_Owner.GetMapper(false);
				try
				{
					((ILease)RemotingServices.GetLifetimeService((MarshalByRefObject)pm)).Renew(EnsuranceTime);
				}
				catch
				{
					pm = m_Owner.GetMapper(true);
					((ILease)RemotingServices.GetLifetimeService((MarshalByRefObject)pm)).Renew(EnsuranceTime);
				}
				return pm;
			}

			public void DeActivate()
			{
				m_Owner = null;
			}

			void IPersistenceMapper.Fetch(ObjectIdList idList, out Datablock datablock, int[] memberIdList)
			{
				try
				{
					GetMapper().Fetch(idList, out datablock, memberIdList);
				}
				catch (RemotingException)
				{
					GetEnsuredMapper().Fetch(idList, out datablock, memberIdList);
				}

			}

			void IPersistenceMapper.FetchIDListWithCondition(AbstractCondition condition, out ObjectIdList result, int maxResults, int offset)
			{
				try
				{
					GetMapper().FetchIDListWithCondition(condition, out result, maxResults, offset);
				}
				catch (RemotingException)
				{
					GetEnsuredMapper().FetchIDListWithCondition(condition, out result, maxResults, offset);
				}
			}

			///<exception cref="ArgumentNullException">Thrown if <paramref name="datablock"/> is null</exception>
			void IPersistenceMapper.Update(Datablock datablock, UpdatePrecondition precondition, out IdTranslationList TranslationList, out int version, out SyncVersion syncVersion, out UpdateResult result)
			{
				if (datablock == null) throw new ArgumentNullException("datablock"); // do not localize
				datablock.Strip();
				GetEnsuredMapper().Update(datablock, precondition, out TranslationList, out version, out syncVersion, out result);
			}

			void IPersistenceMapper.VersionForTime(DateTime clockTime, out int version)
			{
				try
				{
					GetMapper().VersionForTime(clockTime, out version);
				}
				catch (RemotingException)
				{
					GetEnsuredMapper().VersionForTime(clockTime, out version);
				}
			}

			void IPersistenceMapper.TimeForVersion(int version, out DateTime clockTime)
			{
				try
				{
					GetMapper().TimeForVersion(version, out clockTime);
				}
				catch (RemotingException)
				{
					GetEnsuredMapper().TimeForVersion(version, out clockTime);
				}
			}

			bool IPersistenceMapper.SupportsSync
			{
				get
				{
					try
					{
						return GetMapper().SupportsSync;
					}
					catch (RemotingException)
					{
						return GetEnsuredMapper().SupportsSync;
					}
				}
			}

			void IPersistenceMapper.GetChangesSince(SyncVersion syncVersion, SyncVersion[] excludeList, out DBChangeCollection changes, out SyncVersion lastSyncVersion)
			{
				try
				{
					GetMapper().GetChangesSince(syncVersion, excludeList, out changes, out lastSyncVersion);
				}
				catch (RemotingException)
				{
					GetEnsuredMapper().GetChangesSince(syncVersion, excludeList, out changes, out lastSyncVersion);
				}
			}

			SyncVersion IPersistenceMapper.CurrentSyncVersion
			{
				get
				{
					try
					{
						return GetMapper().CurrentSyncVersion;
					}
					catch (RemotingException)
					{
						return GetEnsuredMapper().CurrentSyncVersion;
					}
				}
			}
		}
	}
}
